/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.IOParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.NetworkConfiguration;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.DataLogBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.NetworkNodeBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.SAnalogOutputBlock;
import DE.siemens.ad.logo.model.block.SOutputBlock;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo6;
import DE.siemens.ad.logo.model.visitor.build.UDFConstants;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.NetworkMemoryV7;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;

public class CompilerToLogo7
extends CompilerToLogo6 {
    public void init() {
        super.init();
        ((Logo7)this.fHardware).getMemory("UDF Memory").init(255);
        ((Logo7)this.fHardware).getMemory("Network Memory").init(255);
    }

    protected void initOffsetTableForStartProgramLine() {
        this.fProgramOffsetTable.init(255);
        this.fProgramOffsetTable.setPosition(0);
    }

    protected void putOffsetTable(Block block, int opcode) {
        this.fProgramOffsetTable.setPosition(block.getNumber() - 1, 0);
        this.fProgramOffsetTable.putWord(this.fProgramMemory.putWord(opcode));
    }

    protected void setAnchor(OutputBlock block, String memoryID) {
        int anchorNumber = block.getNumber();
        int byteIndex = (anchorNumber - 1) * 2;
        Memory memory = this.getMemory(memoryID);
        memory.setPosition(byteIndex);
        this.link(block, memory);
    }

    public Object visit(DataLogBlock block) {
        this.setAnchor(block, "Datalog Anchor");
        Memory memory = this.getMemory("Datalog Index Memory");
        memory.putWord(1);
        memory = this.getMemory("Datalog Profile Memory");
        memory.setPosition(0);
        this.fLinker.setMemory(memory);
        DataLogParameter param = (DataLogParameter)block.getParameter();
        ParameterItemList paraItemList = param.getParameterItemList();
        for (int i = 0; i < paraItemList.size(); ++i) {
            ParameterItem paraItem = (ParameterItem)paraItemList.get(i);
            BlockParameter para = paraItem.getParameter();
            Block aBlock = para.getBlock();
            if (aBlock != null) {
                if (paraItem instanceof UDFParameterItem) {
                    ParameterItem sourceParameter = ((UDFParameterItem)paraItem).getRootSourceParameterItem();
                    Block sourceBlock = sourceParameter.getParameter().getBlock();
                    int UDFParaNumber = paraItem.getParameterNumber();
                    int sourceParaNumber = sourceParameter.getParameterNumber();
                    sourceBlock.acceptVisitor(this.fLinker);
                    this.fLinker.fMemory.put(sourceParaNumber);
                    this.fLinker.fMemory.put(UDFParaNumber | 0x80);
                    continue;
                }
                aBlock.acceptVisitor(this.fLinker);
                if (para instanceof IOParameter) {
                    this.fLinker.fMemory.put(255);
                    this.fLinker.fMemory.put(255);
                    continue;
                }
                this.fLinker.fMemory.put(paraItem.getParameterNumber());
                this.fLinker.fMemory.put(255);
                continue;
            }
            this.fLinker.fMemory.putWord(0);
            this.fLinker.fMemory.put(255);
            this.fLinker.fMemory.put(255);
        }
        return null;
    }

    public Object visit(MarkerBlock block) {
        this.setAnchor(block, "Merker");
        return null;
    }

    public Object visit(AnalogMarkerBlock block) {
        this.setAnchor(block, "AnalogMarker");
        return null;
    }

    public Object visit(AnalogOutputBlock block) {
        this.setAnchor(block, "AnalogOuput");
        return null;
    }

    public Object visit(NotBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(0);
        this.fProgramMemory.putWord(0);
        return null;
    }

    public Object visit(NetworkNodeBlock block) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)((Logo7)this.fHardware).getMemory("Network Memory");
        NetworkNodeParameter param = (NetworkNodeParameter)block.getParameter();
        int offset = memory.getOffsetForNetworkBlockInfo(block.getNumberType()) + (block.getNumber() - 1) * 6;
        memory.setPosition(offset);
        if (param.isForSlave()) {
            memory.put(param.getConfiguredBlockNumber());
            memory.put(param.getConfiguredBlockType() | 0x80);
            memory.putDoubleWord(IPV4Utils.getInstance().formatToInt(param.getAddress()));
        } else {
            memory.putWord((param.getBitNumber() & 0xFF) << 10 | param.getVMAddress());
            memory.putDoubleWord(0);
        }
        return null;
    }

    public Object visit(SOutputBlock block) {
        this.setAnchor(block, "Anker network Q1...Qi");
        this.writeSQInfo(block);
        return null;
    }

    public Object visit(SAnalogOutputBlock block) {
        this.setAnchor(block, "Network AQ");
        this.writeSQInfo(block);
        return null;
    }

    private void writeSQInfo(SOutputBlock block) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)((Logo7)this.fHardware).getMemory("Network Memory");
        SOutputParameter parameter = (SOutputParameter)block.getParameter();
        int offset = memory.getOffsetForNetworkBlockInfo(block.getNumberType()) + (block.getNumber() - 1) * 5;
        memory.setPosition(offset);
        memory.putDoubleWord(IPV4Utils.getInstance().formatToInt(parameter.getAddress()));
        memory.put(parameter.getConfiguredBlockNumber());
    }

    public void compile(WiringDiagram wd, Hardware hw) {
        super.compile(wd, hw);
        this.handleUDF(wd, hw);
        this.writeNetworkParameter(wd, hw);
    }

    private void writeNetworkParameter(WiringDiagram wd, Hardware hw) {
        NetworkMemoryV7 memory = (NetworkMemoryV7)this.getMemory("Network Memory");
        NetworkConfiguration config = wd.getNetworkInfo();
        memory.writeConnections(config);
        memory.writeBlockVMMappingInfo(wd.getBlockVMMappingInfo(), this.fProgramOffsetTable);
    }

    protected void putNameOffsetTable(Memory blockNameOffsetTable, int progLineNumber) {
        blockNameOffsetTable.putWord(progLineNumber);
    }

    protected void handleUDF(WiringDiagram wd, Hardware hw) {
        UDFBlock macro3;
        int i;
        Block srcBlock;
        int specialBlockCount = hw.getIntProperty("maxPAEncodingCountInUDF");
        Memory memory = this.getMemory("UDF Memory");
        memory.setPosition(0);
        Map<Block, UDFBlock> macroBlockMap = wd.getBlockToMacroMap();
        if (macroBlockMap.size() == 0) {
            memory.putWord(0);
            return;
        }
        Vector<Long> macroGUIDs = new Vector<Long>();
        Vector<UDFBlock> macroTypes = new Vector<UDFBlock>();
        UDFBlock[] macroArray = new UDFBlock[64];
        Vector<UDFBlock> topLevelList = new Vector<UDFBlock>();
        for (UDFBlock macro2 : macroBlockMap.values()) {
            if (wd.getOutestBlock(macro2) != macro2) continue;
            if (macroArray[macro2.getNumber() - 1] == null) {
                macroArray[macro2.getNumber() - 1] = macro2;
                topLevelList.add(macro2);
            }
            if (macroGUIDs.contains(macro2.getGuid())) continue;
            macroGUIDs.add(macro2.getGuid());
            macroTypes.add(macro2);
        }
        memory.putWord(macroGUIDs.size());
        memory.putWord(64);
        memory.putWord(topLevelList.size());
        for (UDFBlock macro2 : macroTypes) {
            int i2;
            int idx;
            int i3;
            memory.putDoubleWord((int)(macro2.getGuid() & 0xFFFFFFFFFFFFFFFFL));
            memory.putDoubleWord((int)(macro2.getGuid() >> 32 & 0xFFFFFFFFFFFFFFFFL));
            memory.put(macro2.getConnectorCounts());
            int[] nameBytes = new int[8];
            for (i3 = 0; i3 < nameBytes.length && i3 < macro2.getIdentifier().length(); ++i3) {
                nameBytes[i3] = macro2.getIdentifier().charAt(i3);
            }
            memory.put(nameBytes);
            memory.put(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
            for (i3 = 0; i3 < macro2.getOutConnectorCount(); ++i3) {
                Block block = macro2.getOutputDeputy(i3).getInConnector(0).getLinkedBlock();
                while (block instanceof DeputyBlock) {
                    block = ((DeputyBlock)block).getInConnector(0).getLinkedBlock();
                }
                memory.put(macro2.getChildBlockOrder(block));
                int detail = 0;
                if (block.getNumberType() != 0) {
                    detail |= 0x40;
                }
                memory.put(detail);
            }
            for (i3 = macro2.getOutConnectors().length; i3 < 4; ++i3) {
                memory.put(255);
                memory.put(255);
            }
            ParameterItemList paramList = ((UDFBlockParameter)macro2.getParameter()).getParameterItems();
            for (idx = 0; idx < paramList.size(); ++idx) {
                UDFParameterItem item = (UDFParameterItem)paramList.get(idx);
                BlockParameter blockParam = item.getRootSourceParameterItem().getParameter();
                srcBlock = blockParam.getBlock();
                int detail = 0;
                ParameterItemList srcBlockItemList = srcBlock.getParameter().getParameterItems();
                for (int i4 = 0; i4 < srcBlockItemList.size(); ++i4) {
                    if (!((ParameterItem)srcBlockItemList.get(i4)).getIdentifier().equals(item.getRootSourceParameterItem().getIdentifier())) continue;
                    detail |= i4;
                    break;
                }
                memory.put(macro2.getChildBlockOrder(srcBlock));
                memory.put(detail);
            }
            for (i2 = paramList.size(); i2 < 8; ++i2) {
                memory.put(255);
                memory.put(255);
            }
            for (idx = 0; idx < paramList.size(); ++idx) {
                nameBytes = new int[4];
                UDFParameterItem item = (UDFParameterItem)paramList.get(idx);
                for (int i5 = 0; i5 < nameBytes.length && i5 < item.getIdentifier().length(); ++i5) {
                    nameBytes[i5] = item.getIdentifier().charAt(i5);
                }
                memory.put(nameBytes);
            }
            for (i2 = paramList.size(); i2 < 8; ++i2) {
                memory.putDoubleWord(0);
            }
        }
        int[] types = new int[64];
        for (i = 0; i < 64; ++i) {
            types[i] = 255;
        }
        for (i = 0; i < macroArray.length; ++i) {
            if (macroArray[i] == null) continue;
            types[i] = macroGUIDs.indexOf(macroArray[i].getGuid());
        }
        memory.put(types);
        for (i = 0; i < hw.getMaxResource(0); ++i) {
            macro3 = null;
            Block block = wd.getExpansionBlockByNumber(0, i + 1);
            if (block != null) {
                if (wd.getOutestBlock(block) instanceof UDFBlock) {
                    macro3 = (UDFBlock)wd.getOutestBlock(block);
                }
            } else {
                memory.put(255);
                memory.putWord(65535);
                continue;
            }
            if (macro3 != null) {
                memory.put(macro3.getNumber() - 1);
            } else {
                memory.put(255);
            }
            int inputInfo = 0;
            for (int j = 3; j >= 0; --j) {
                inputInfo <<= 4;
                inputInfo |= this.getInConnectorInfoByte(block, j, macro3);
            }
            memory.putWord(inputInfo);
        }
        for (i = 0; i < specialBlockCount; ++i) {
            macro3 = null;
            int paEncoding = UDFConstants.getPAEncoding(i);
            Block block = wd.getExpansionBlockByOpcode(paEncoding | 0x1000000, ((Logo)wd.getHardware()).calculateBlockNumber(paEncoding));
            if (block != null) {
                if (wd.getOutestBlock(block) instanceof UDFBlock) {
                    macro3 = (UDFBlock)wd.getOutestBlock(block);
                }
            } else {
                memory.put(255);
                memory.put(255);
                continue;
            }
            if (macro3 != null) {
                memory.put(macro3.getNumber() - 1);
            } else {
                memory.put(255);
            }
            int inputInfo = this.getInConnectorInfoByte(block, 0, macro3) | 0xF0;
            memory.put(inputInfo);
        }
        for (i = 0; i < 64; ++i) {
            macro3 = macroArray[i];
            UDFBlock upperMacro = null;
            if (macro3 == null) {
                memory.put(255);
                memory.putDoubleWord(-1);
                continue;
            }
            upperMacro = wd.getMacroBlock(macro3);
            if (upperMacro == null) {
                memory.put(254);
            } else {
                memory.put(upperMacro.getNumber() - 1);
            }
            int inputInfo = 0;
            memory.putDoubleWord(inputInfo);
        }
        Collections.sort(topLevelList, new Comparator<Block>(){

            @Override
            public int compare(Block o1, Block o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        this.fLinker.setMemory(memory);
        for (UDFBlock macro3 : topLevelList) {
            int i6;
            int i7;
            memory.put(macro3.getNumber() - 1);
            memory.put(255);
            for (i7 = 0; i7 < 8; ++i7) {
                if (i7 >= macro3.getInConnectorCount() - 1) {
                    memory.putWord(65535);
                    continue;
                }
                BlockConnector connector = macro3.getFirstBlockInputConnector(macro3.getInConnector(i7));
                Block owner = connector.getOwner();
                owner.acceptVisitor(this.fLinker);
            }
            for (i7 = 0; i7 < 4; ++i7) {
                if (i7 >= macro3.getOutConnectorCount()) {
                    memory.putWord(65535);
                    continue;
                }
                OutBlockConnector connector = macro3.getBlockOutConnector(macro3.getOutConnector(i7));
                Block owner = connector.getOwner();
                owner.acceptVisitor(this.fLinker);
            }
            ParameterItemList paramList = ((UDFBlockParameter)macro3.getParameter()).getParameterItems();
            for (i6 = 0; i6 < 8; ++i6) {
                if (i6 >= paramList.size()) {
                    memory.putWord(65535);
                    continue;
                }
                UDFParameterItem item = (UDFParameterItem)paramList.get(i6);
                BlockParameter blockParam = item.getRootSourceParameterItem().getParameter();
                srcBlock = blockParam.getBlock();
                int aWord = this.fLinker.convertToPrgLine(srcBlock.getNumber()) & 0x3FF;
                aWord |= item.getRootSourceParameterItem().getParameterNumber() << 10;
                memory.putWord(aWord &= 0xFFFF);
            }
            for (i6 = 0; i6 < 8; ++i6) {
                memory.put(this.getInputOutputRelation(macro3, i6));
            }
            int[] userDefinedNameBytes = new int[8];
            if (macro3.isUserDefinedNameAvailable()) {
                for (int i8 = 0; i8 < userDefinedNameBytes.length && i8 < macro3.getUserDefinedName().length(); ++i8) {
                    userDefinedNameBytes[i8] = macro3.getUserDefinedName().charAt(i8);
                }
            }
            memory.put(userDefinedNameBytes);
        }
    }

    private int getConnectorIndexOfInput(InBlockConnector connector, UDFBlock udf) {
        if (connector instanceof ParameterInBlockConnector) {
            return 15;
        }
        OutBlockConnector preConnector = connector.getLinkedConnector();
        if (preConnector == null) {
            return 15;
        }
        Block owner = preConnector.getOwner();
        if (owner instanceof DeputyBlock) {
            while (((DeputyBlock)owner).getParent() != udf) {
                preConnector = owner.getInConnector(0).getLinkedConnector();
                if (preConnector == null) {
                    return 15;
                }
                owner = preConnector.getOwner();
                if (owner instanceof DeputyBlock) continue;
            }
            if (!(owner instanceof DeputyBlock)) {
                return 15;
            }
            for (int i = 0; i < udf.getInConnectorCount() - 1; ++i) {
                if (udf.getInputDeputy(i) != (DeputyBlock)owner) continue;
                return i;
            }
            return 15;
        }
        return 15;
    }

    private int getInConnectorInfoByte(Block block, int index, UDFBlock parent) {
        if (index < block.getInConnectorCount()) {
            if (parent != null) {
                return this.getConnectorIndexOfInput(block.getInConnector(index), parent);
            }
            OutBlockConnector out = block.getInConnector(index).getLinkedConnector();
            if (out != null) {
                if (out.getOwner() instanceof DeputyBlock) {
                    return ((DeputyBlock)out.getOwner()).getParent().getOutConnectorPosition(out);
                }
                if (out.getOwner() instanceof Block) {
                    return 0;
                }
            }
        }
        return 15;
    }

    private int getInputOutputRelation(UDFBlock udfBlock, int inIndex) {
        if (inIndex >= udfBlock.getInConnectorCount()) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < udfBlock.getOutConnectorCount(); ++i) {
            if (!udfBlock.isConnected(inIndex, i)) continue;
            ret |= 1 << i;
        }
        return ret;
    }

    public void setHardware(Hardware hw) {
        this.fHardware = hw;
    }
}

